/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.test.common;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.openoffice.test.common.FileUtil;

public class SystemUtil {
    private static Logger LOG = Logger.getLogger(SystemUtil.class.getName());
    private static Clipboard sysClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    private static final String OSNAME = System.getProperty("os.name");
    public static final File SCRIPT_TEMP_DIR = new File(System.getProperty("user.home"), ".ootest");

    public static void beep() {
        System.out.print("\u0007\u0007\u0007");
        System.out.flush();
    }

    public static boolean isWindows() {
        return OSNAME.startsWith("Windows");
    }

    public static boolean isLinux() {
        return OSNAME.startsWith("Linux");
    }

    public static boolean isMac() {
        return OSNAME.startsWith("Mac");
    }

    public static String getEnv(String name, String defaultValue) {
        String value = System.getenv(name);
        return value == null ? defaultValue : value;
    }

    public static void setClipboardText(String s) {
        StringSelection ss = new StringSelection(s);
        sysClipboard.setContents(ss, ss);
    }

    public static String getClipboardText() {
        Transferable contents = SystemUtil.getTransferable();
        if (contents == null || !contents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return "";
        }
        try {
            return (String)contents.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception ex) {
            return "";
        }
    }

    private static Transferable getTransferable() {
        int i = 0;
        while (i < 25) {
            try {
                return sysClipboard.getContents(null);
            }
            catch (IllegalStateException e) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++i;
            }
        }
        throw new RuntimeException("System Clipboard is not ready");
    }

    /*
     * Loose catch block
     */
    public static int execScript(String content, boolean spawn) {
        int n;
        File file;
        block12: {
            file = null;
            file = FileUtil.getUniqueFile(SCRIPT_TEMP_DIR, "tempscript", ".bat");
            FileUtil.writeStringToFile(file.getAbsolutePath(), content);
            String[] cmd = SystemUtil.isWindows() ? new String[]{file.getAbsolutePath()} : new String[]{"sh", file.getAbsolutePath()};
            StringBuffer output = new StringBuffer();
            int code = SystemUtil.exec(cmd, null, spawn, output, output);
            LOG.info(String.valueOf(content) + "\n" + "Exit Code: " + code + "\n" + output);
            n = code;
            if (file == null) break block12;
            try {
                file.deleteOnExit();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
        catch (Exception e) {
            if (file != null) {
                try {
                    file.deleteOnExit();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return -1;
            catch (Throwable throwable) {
                if (file != null) {
                    try {
                        file.deleteOnExit();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    public static int exec(String[] command, String workingDir, boolean spawn, StringBuffer output, StringBuffer error) {
        Process process = null;
        File dir = workingDir == null ? null : new File(workingDir);
        int code = 0;
        try {
            process = Runtime.getRuntime().exec(command, null, dir);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        StreamPump inputPump = new StreamPump(output, process.getInputStream());
        StreamPump errorPump = new StreamPump(error, process.getErrorStream());
        inputPump.start();
        errorPump.start();
        try {
            if (!spawn) {
                code = process.waitFor();
                inputPump.join();
                errorPump.join();
            }
            return code;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static void sleep(double second) {
        try {
            Thread.sleep((long)(second * 1000.0));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static List<String> getProcesses() {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            StringBuffer output = new StringBuffer();
            if (SystemUtil.isWindows()) {
                File file = File.createTempFile("ssssss", ".js");
                String contents = "var e=new Enumerator(GetObject(\"winmgmts:\").InstancesOf(\"Win32_process\"));\n\r";
                contents = String.valueOf(contents) + "for (;!e.atEnd();e.moveNext()) {\n\r";
                contents = String.valueOf(contents) + "WScript.Echo(e.item ().CommandLine);}";
                FileUtil.writeStringToFile(file.getAbsolutePath(), contents);
            }
            BufferedReader reader = new BufferedReader(new StringReader(output.toString()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                ret.add(line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret;
    }

    public static String[] parseCommandLine(String line) {
        ArrayList<String> arguments = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(line, "\"' ", true);
        int state = 0;
        StringBuffer current = new StringBuffer();
        block4: while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            switch (state) {
                case 1: {
                    if ("'".equals(token)) {
                        state = 3;
                        break;
                    }
                    current.append(token);
                    break;
                }
                case 2: {
                    if ("\"".equals(token)) {
                        state = 3;
                        break;
                    }
                    current.append(token);
                    break;
                }
                default: {
                    if ("'".equals(token)) {
                        state = 1;
                        break;
                    }
                    if ("\"".equals(token)) {
                        state = 2;
                        break;
                    }
                    if (" ".equals(token)) {
                        if (current.length() <= 0) continue block4;
                        arguments.add(current.toString());
                        current = new StringBuffer();
                        break;
                    }
                    current.append(token);
                }
            }
        }
        if (current.length() > 0) {
            arguments.add(current.toString());
        }
        return arguments.toArray(new String[arguments.size()]);
    }

    public static String getIPAddress() {
        InetAddress addr = null;
        try {
            addr = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return addr.getHostAddress().toString();
    }

    public static class StreamPump
    extends Thread {
        StringBuffer stringBuffer = null;
        InputStream inputStream = null;

        public StreamPump(StringBuffer stringBuffer, InputStream inputStream) {
            this.stringBuffer = stringBuffer;
            this.inputStream = inputStream;
        }

        @Override
        public void run() {
            block13: {
                InputStreamReader reader = null;
                try {
                    try {
                        reader = new InputStreamReader(this.inputStream);
                        char[] buf = new char[1024];
                        int count = 0;
                        while ((count = reader.read(buf)) != -1) {
                            if (this.stringBuffer == null) continue;
                            this.stringBuffer.append(buf, 0, count);
                        }
                    }
                    catch (IOException iOException) {
                        if (reader == null) break block13;
                        try {
                            reader.close();
                        }
                        catch (IOException iOException2) {}
                    }
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    }
}

