/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.test.vcl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import org.openoffice.test.vcl.client.SmartId;

public class IDList {
    private HashMap<String, String> map = new HashMap();
    private File dir = null;

    public IDList(File dir) {
        this.dir = dir;
        this.load();
    }

    private void readFile(File file, HashMap<String, String> map) {
        block13: {
            BufferedReader reader = null;
            try {
                try {
                    reader = new BufferedReader(new FileReader(file));
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        String[] parts;
                        if ((line = line.trim()).length() == 0 || (parts = line.split(" ")).length != 2) continue;
                        map.put(parts[0], parts[1]);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (reader == null) break block13;
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public void load() {
        File[] files;
        if (this.dir == null) {
            return;
        }
        this.map.clear();
        ArrayList<File> validFiles = new ArrayList<File>();
        File[] fileArray = files = this.dir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile() && file.getName().endsWith(".lst")) {
                validFiles.add(file);
            }
            ++n2;
        }
        Collections.sort(validFiles, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (File file : validFiles) {
            this.readFile(file, this.map);
        }
    }

    public SmartId getId(String id) {
        int i;
        String value = this.map.get(id);
        if (value == null && (i = id.indexOf("_")) >= 0) {
            value = this.map.get(id.substring(++i));
        }
        if (value != null) {
            id = value;
        }
        try {
            return new SmartId(Long.parseLong(id));
        }
        catch (NumberFormatException numberFormatException) {
            return new SmartId(id);
        }
    }
}

