/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.test.vcl.client;

import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openoffice.test.vcl.client.SmartId;

public class VclHookException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    public static final int SVT_START = 22000;
    public static final int S_GPF_ABORT = 22000;
    public static final int S_APP_SHUTDOWN = 22001;
    public static final int S_SID_EXECUTE_FAILED_NO_DISPATCHER = 22002;
    public static final int S_SID_EXECUTE_FAILED = 22003;
    public static final int S_UNO_PROPERTY_NITIALIZE_FAILED = 22004;
    public static final int S_RESETAPPLICATION_FAILED_COMPLEX = 22005;
    public static final int S_RESETAPPLICATION_FAILED_UNKNOWN = 22006;
    public static final int S_NO_ACTIVE_WINDOW = 22007;
    public static final int S_NO_DIALOG_IN_GETACTIVE = 22008;
    public static final int S_NO_POPUP = 22009;
    public static final int S_NO_SUBMENU = 22010;
    public static final int S_CONTROLTYPE_NOT_SUPPORTED = 22011;
    public static final int S_SELECTION_BY_ATTRIBUTE_ONLY_DIRECTORIES = 22012;
    public static final int S_NO_MORE_FILES = 22013;
    public static final int S_UNKNOWN_METHOD = 22014;
    public static final int S_INVALID_PARAMETERS = 22015;
    public static final int S_POINTER_OUTSIDE_APPWIN = 22016;
    public static final int S_UNKNOWN_COMMAND = 22017;
    public static final int S_WIN_NOT_FOUND = 22018;
    public static final int S_WIN_INVISIBLE = 22019;
    public static final int S_WIN_DISABLED = 22020;
    public static final int S_NUMBER_TOO_BIG = 22021;
    public static final int S_NUMBER_TOO_SMALL = 22022;
    public static final int S_WINDOW_DISAPPEARED = 22023;
    public static final int S_ERROR_SAVING_IMAGE = 22024;
    public static final int S_INVALID_POSITION = 22025;
    public static final int S_SPLITWIN_NOT_FOUND = 22026;
    public static final int S_INTERNAL_ERROR = 22027;
    public static final int S_NO_STATUSBAR = 22028;
    public static final int S_ITEMS_INVISIBLE = 22029;
    public static final int S_TABPAGE_NOT_FOUND = 22030;
    public static final int S_TRISTATE_NOT_ALLOWED = 22031;
    public static final int S_ERROR_IN_SET_TEXT = 22032;
    public static final int S_ATTEMPT_TO_WRITE_READONLY = 22033;
    public static final int S_NO_SELECT_FALSE = 22034;
    public static final int S_ENTRY_NOT_FOUND = 22035;
    public static final int S_METHOD_FAILED = 22036;
    public static final int S_HELPID_ON_TOOLBOX_NOT_FOUND = 22037;
    public static final int S_BUTTON_DISABLED_ON_TOOLBOX = 22038;
    public static final int S_BUTTON_HIDDEN_ON_TOOLBOX = 22039;
    public static final int S_CANNOT_MAKE_BUTTON_VISIBLE_IN_TOOLBOX = 22040;
    public static final int S_TEAROFF_FAILED = 22041;
    public static final int S_NO_SELECTED_ENTRY_DEPRECATED = 22042;
    public static final int S_SELECT_DESELECT_VIA_STRING_NOT_IMPLEMENTED = 22043;
    public static final int S_ALLOWED_ONLY_IN_FLOATING_MODE = 22044;
    public static final int S_ALLOWED_ONLY_IN_DOCKING_MODE = 22045;
    public static final int S_SIZE_NOT_CHANGEABLE = 22046;
    public static final int S_NO_OK_BUTTON = 22047;
    public static final int S_NO_CANCEL_BUTTON = 22048;
    public static final int S_NO_YES_BUTTON = 22049;
    public static final int S_NO_NO_BUTTON = 22050;
    public static final int S_NO_RETRY_BUTTON = 22051;
    public static final int S_NO_HELP_BUTTON = 22052;
    public static final int S_NO_DEFAULT_BUTTON = 22053;
    public static final int S_BUTTON_ID_NOT_THERE = 22054;
    public static final int S_BUTTONID_REQUIRED = 22055;
    public static final int S_UNKNOWN_TYPE = 22056;
    public static final int S_UNPACKING_STORAGE_FAILED = 22057;
    public static final int S_NO_LIST_BOX_BUTTON = 22058;
    public static final int S_UNO_URL_EXECUTE_FAILED_NO_DISPATCHER = 22059;
    public static final int S_UNO_URL_EXECUTE_FAILED_NO_FRAME = 22060;
    public static final int S_NO_MENU = 22061;
    public static final int S_NO_SELECTED_ENTRY = 22062;
    public static final int S_UNO_URL_EXECUTE_FAILED_DISABLED = 22063;
    public static final int S_NO_SCROLLBAR = 22064;
    public static final int S_NO_SAX_PARSER = 22065;
    public static final int S_CANNOT_CREATE_DIRECTORY = 22066;
    public static final int S_DIRECTORY_NOT_EMPTY = 22067;
    public static final int S_DEPRECATED = 22068;
    public static final int S_SIZE_BELOW_MINIMUM = 22069;
    public static final int S_CANNOT_FIND_FLOATING_WIN = 22070;
    public static final int S_NO_LIST_BOX_STRING = 22071;
    public static final int S_SLOT_IN_EXECUTE = 22072;
    public static Properties MESSAGES = new Properties();
    private SmartId id = null;
    private String message = null;
    private int code = -1;
    private Properties properties = new Properties();

    static {
        MESSAGES.put(new Integer(22000), "Program aborted with GPF");
        MESSAGES.put(new Integer(22001), "Application has been shut down");
        MESSAGES.put(new Integer(22002), "Slot ID cannot be executed. No ActiveDispatcher");
        MESSAGES.put(new Integer(22003), "Slot ID could not be executed");
        MESSAGES.put(new Integer(22004), "UnoSlot: Properties could not be initialized");
        MESSAGES.put(new Integer(22005), "ResetApplication failed: too complex");
        MESSAGES.put(new Integer(22006), "ResetApplication failed: unknown window type");
        MESSAGES.put(new Integer(22007), "No active window found (GetNextCloseWindow)");
        MESSAGES.put(new Integer(22008), "GetActive does not return a dialog! Inform development");
        MESSAGES.put(new Integer(22009), "Pop-up menu not open");
        MESSAGES.put(new Integer(22010), "Submenu does not exist");
        MESSAGES.put(new Integer(22011), "ControlType ($Arg1) is not supported");
        MESSAGES.put(new Integer(22012), "Selection by attributes only possible for directories");
        MESSAGES.put(new Integer(22013), "No more files");
        MESSAGES.put(new Integer(22014), "Unknown method '($Arg1)' on ($Arg2)");
        MESSAGES.put(new Integer(22015), "Invalid Parameters");
        MESSAGES.put(new Integer(22016), "Pointer not inside application window at '($Arg1)'");
        MESSAGES.put(new Integer(22017), "Unknown command '($Arg1)'");
        MESSAGES.put(new Integer(22018), "($Arg1) could not be found");
        MESSAGES.put(new Integer(22019), "($Arg1) is not visible");
        MESSAGES.put(new Integer(22020), "($Arg1) could not be accessed. Disabled");
        MESSAGES.put(new Integer(22021), "Entry number ($Arg2) is too large in ($Arg1). Max. allowed is ($Arg3)");
        MESSAGES.put(new Integer(22022), "The entry number ($Arg2) is too small in ($Arg1). Min allowed is ($Arg3)");
        MESSAGES.put(new Integer(22023), "Window disappeared in the meantime at ($Arg1)");
        MESSAGES.put(new Integer(22024), "Error #($Arg1) when saving the image");
        MESSAGES.put(new Integer(22025), "Invalid position at ($Arg1)");
        MESSAGES.put(new Integer(22026), "SplitWindow not found at ($Arg1)");
        MESSAGES.put(new Integer(22027), "Internal error at ($Arg1)");
        MESSAGES.put(new Integer(22028), "No status bar at ($Arg1)");
        MESSAGES.put(new Integer(22029), "The items are hidden at ($Arg1)");
        MESSAGES.put(new Integer(22030), "Tab page not found at ($Arg1)");
        MESSAGES.put(new Integer(22031), "Tristate cannot be set at ($Arg1)");
        MESSAGES.put(new Integer(22032), "Set text did not function");
        MESSAGES.put(new Integer(22033), "Attempt to write on read-only ($Arg1)");
        MESSAGES.put(new Integer(22034), "Select FALSE not allowed. Use MultiSelect at ($Arg1)");
        MESSAGES.put(new Integer(22035), "\"($Arg2)\" entry at ($Arg1) not found");
        MESSAGES.put(new Integer(22036), "($Arg1) of entry \"($Arg2)\" failed");
        MESSAGES.put(new Integer(22037), "HelpID in ToolBox not found at ($Arg1)");
        MESSAGES.put(new Integer(22038), "The button is disabled in ToolBox at ($Arg1)");
        MESSAGES.put(new Integer(22039), "The button is hidden in ToolBox at ($Arg1)");
        MESSAGES.put(new Integer(22040), "Button cannot be made visible in ToolBox at ($Arg1)");
        MESSAGES.put(new Integer(22041), "TearOff failed in ToolBox at ($Arg1)");
        MESSAGES.put(new Integer(22042), "No entry is selected in TreeListBox at ($Arg1)");
        MESSAGES.put(new Integer(22062), "No entry is selected in ($Arg2) at ($Arg1)");
        MESSAGES.put(new Integer(22043), "Select/Deselect with MESSAGES.put(new Integer(not implemented at ($Arg1)");
        MESSAGES.put(new Integer(22044), "Method only allowed in floating mode at ($Arg1)");
        MESSAGES.put(new Integer(22045), "Method only allowed in docking mode at ($Arg1)");
        MESSAGES.put(new Integer(22046), "Size cannot be altered at ($Arg1)");
        MESSAGES.put(new Integer(22047), "There is no OK button at ($Arg1)");
        MESSAGES.put(new Integer(22048), "There is no Cancel button at ($Arg1)");
        MESSAGES.put(new Integer(22049), "There is no Yes button at ($Arg1)");
        MESSAGES.put(new Integer(22050), "There is no No button at ($Arg1)");
        MESSAGES.put(new Integer(22051), "There is no Repeat button at ($Arg1)");
        MESSAGES.put(new Integer(22052), "There is no Help button at ($Arg1)");
        MESSAGES.put(new Integer(22053), "There is no Default button defined at ($Arg1)");
        MESSAGES.put(new Integer(22054), "There is no button with ID ($Arg1) at ($Arg2)");
        MESSAGES.put(new Integer(22055), "A button ID needs to be given at ($Arg1)");
        MESSAGES.put(new Integer(22056), "Unknown object type ($Arg1) from UId or method '($Arg2)' not supported");
        MESSAGES.put(new Integer(22057), "Unpacking storage \"($Arg1)\" to \"($Arg2)\" failed");
        MESSAGES.put(new Integer(22058), "ListBoxButton does not exist in ($Arg1)");
        MESSAGES.put(new Integer(22059), "UNO URL \"($Arg1)\" could not be executed: No dispatcher was found.");
        MESSAGES.put(new Integer(22060), "UNO URL \"($Arg1)\" could not be executed: No ActiveFrame on desktop.");
        MESSAGES.put(new Integer(22061), "There is no menu at ($Arg1)");
        MESSAGES.put(new Integer(22063), "UNO URL \"($Arg1)\" could not be run: Disabled");
        MESSAGES.put(new Integer(22064), "No scroll bar at ($Arg1)");
        MESSAGES.put(new Integer(22065), "No SAX Parser when using ($Arg1). Initialize with 'SAXReadFile' first.");
        MESSAGES.put(new Integer(22066), "Cannot create Directory: \"($Arg1)\"");
        MESSAGES.put(new Integer(22067), "Directory has to be Empty to unpack to. Directory: \"($Arg1)\"");
        MESSAGES.put(new Integer(22068), "Deprecated! Please change the script.");
        MESSAGES.put(new Integer(22069), "The Size is below the minimum. x=($Arg1) ,y=($Arg2)");
        MESSAGES.put(new Integer(22070), "Cannot find FloatingWindow for floating DockingWindow at ($Arg1).");
        MESSAGES.put(new Integer(22071), "String does not exist in ($Arg1)");
        MESSAGES.put(new Integer(22072), "Another Slot is being executed already.");
    }

    public VclHookException(String message) {
        this(null, message);
    }

    public VclHookException(SmartId id, String message) {
        this.id = id;
        this.message = message;
        if (id != null) {
            this.parse();
        }
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    private void parse() {
        if (this.message == null) {
            return;
        }
        this.message = this.message.replaceAll("%Method=([^%]*)%", "$1");
        this.message = this.message.replaceAll("%RType=([^%]*)%", "$1");
        this.message = this.message.replaceAll("%RCommand=([^%]*)%", "$1");
        this.message = this.message.replaceAll("%UId=([^%]*)%", "$1");
        int start = -1;
        int sep = -1;
        int end = -1;
        int pos = 0;
        String key = null;
        String value = null;
        while ((start = this.message.indexOf(37, pos)) != -1 && (sep = this.message.indexOf(61, start + 1)) != -1 && (end = this.message.indexOf(37, sep + 1)) != -1) {
            key = this.message.substring(start + 1, sep);
            value = this.message.substring(sep + 1, end);
            pos = end + 1;
            this.properties.put(key, value);
        }
        String resId = this.properties.getProperty("ResId");
        if (resId == null) {
            return;
        }
        this.code = Integer.parseInt(resId);
        String originalMsg = (String)MESSAGES.get(this.code);
        if (originalMsg == null) {
            return;
        }
        Pattern pattern = Pattern.compile("\\(\\$([^\\)]*)\\)");
        Matcher matcher = pattern.matcher(originalMsg);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String rep = this.properties.getProperty(matcher.group(1), matcher.group()).replace("$", "\\$");
            matcher.appendReplacement(result, rep);
        }
        matcher.appendTail(result);
        this.message = "ID:" + this.id + " - " + result.toString();
    }

    public int getCode() {
        return this.code;
    }
}

