/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.test.common;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.openoffice.test.common.FileUtil;

public class GraphicsUtil {
    static final double ERR_RANGLE_RECTANGLE = 0.0;
    static final double ERR_RANGLE_ELLIPSE = 1.0;

    public static BufferedImage loadImage(String file) {
        BufferedImage image = null;
        FileInputStream in = null;
        try {
            try {
                in = new FileInputStream(file);
                image = ImageIO.read(in);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        return image;
    }

    public static void storeImage(BufferedImage image, String imgFile) {
        File file = new File(imgFile);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(file);
                ImageIO.write((RenderedImage)image, FileUtil.getFileExtName(imgFile), fos);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static BufferedImage screenshot() {
        return GraphicsUtil.screenshot(null, null);
    }

    public static BufferedImage screenshot(Rectangle area) {
        return GraphicsUtil.screenshot(null, area);
    }

    public static BufferedImage screenShot(String filename) {
        return GraphicsUtil.screenshot(filename, null);
    }

    public static BufferedImage screenshot(String filename, Rectangle area) {
        try {
            Robot robot = new Robot();
            if (area == null) {
                area = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
            }
            BufferedImage capture = robot.createScreenCapture(area);
            if (filename != null) {
                GraphicsUtil.storeImage(capture, filename);
            }
            return capture;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Rectangle findRectangle(Rectangle rect, int color) {
        return GraphicsUtil.findRectangle(GraphicsUtil.screenshot(rect), color);
    }

    public static Rectangle findRectangle(BufferedImage src, int color) {
        Rectangle re = new Rectangle();
        BufferedImage dst = new BufferedImage(src.getWidth(), src.getHeight(), 2);
        int x = 0;
        while (x < dst.getWidth()) {
            int y = 0;
            while (y < dst.getHeight()) {
                dst.setRGB(x, y, -1);
                ++y;
            }
            ++x;
        }
        Graphics g = dst.getGraphics();
        g.setColor(Color.black);
        int sx = -1;
        int sy = 0;
        int ex = 0;
        int ey = 0;
        int x2 = 0;
        while (x2 < src.getWidth()) {
            int y = 0;
            while (y < src.getHeight()) {
                int rgbSrc = src.getRGB(x2, y);
                if (rgbSrc == color) {
                    if (sx == -1) {
                        sx = x2;
                        sy = y;
                    }
                    ex = x2;
                    ey = y;
                }
                ++y;
            }
            ++x2;
        }
        g.fillRect(sx, sy, ex - sx + 1, ey - sy + 1);
        int perimeter = 2 * (ex - sx + ey - sy);
        int errMax = (int)((double)perimeter * 0.0);
        if (!GraphicsUtil.detect(src, color, dst, -16777216, errMax) || !GraphicsUtil.detect(dst, -16777216, src, color, errMax)) {
            return null;
        }
        re.setBounds(sx, sy, ex - sx, ey - sy);
        if (re.width < 2 || re.height < 2) {
            return null;
        }
        return re;
    }

    protected static boolean detect(BufferedImage src, int colorSrc, BufferedImage dst, int colorDst, double errMax) {
        int errCount = 0;
        int x = 0;
        while (x < src.getWidth()) {
            int y = 0;
            while (y < src.getHeight()) {
                int rgbDst;
                int rgbSrc = src.getRGB(x, y);
                if (rgbSrc == colorSrc && (rgbDst = dst.getRGB(x, y)) != colorDst) {
                    ++errCount;
                }
                ++y;
            }
            ++x;
        }
        return (double)errCount <= errMax;
    }
}

