/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.test.vcl.client;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.openoffice.test.vcl.client.CommunicationListener;
import org.openoffice.test.vcl.client.CommunicationManager;
import org.openoffice.test.vcl.client.Constant;

public class Handshaker
implements CommunicationListener,
Constant {
    private static Logger logger = Logger.getLogger("com.ibm.vclhook");
    private CommunicationManager communicationManager = null;

    public Handshaker(CommunicationManager communicationManager) {
        this.communicationManager = communicationManager;
        this.communicationManager.addListener(this);
    }

    @Override
    public void received(int headerType, byte[] header, byte[] data) {
        if (headerType == 2) {
            int handshakeType = data[1] + ((data[0] & 0xFF) << 8);
            switch (handshakeType) {
                case 257: {
                    logger.log(Level.CONFIG, "Receive Handshake - CH_REQUEST_HandshakeAlive");
                    this.sendHandshake(258);
                    break;
                }
                case 260: {
                    logger.log(Level.CONFIG, "Receive Handshake - CH_REQUEST_ShutdownLink");
                    this.sendHandshake(261);
                    break;
                }
                case 261: {
                    logger.log(Level.CONFIG, "Receive Handshake - CH_ShutdownLink");
                    this.communicationManager.stop();
                    break;
                }
                case 262: {
                    logger.log(Level.CONFIG, "Receive Handshake - CH_SetApplication - app");
                }
            }
        }
    }

    public void sendHandshake(int handshakeType) {
        this.sendHandshake(handshakeType, new byte[0]);
    }

    public void sendHandshake(int handshakeType, byte[] data) {
        byte[] realData = new byte[data.length + 2];
        realData[0] = (byte)(handshakeType >>> 8 & 0xFF);
        realData[1] = (byte)(handshakeType >>> 0 & 0xFF);
        System.arraycopy(data, 0, realData, 2, data.length);
        this.communicationManager.sendPackage(2, null, realData);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }
}

