/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.test.vcl.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.openoffice.test.vcl.client.CommunicationException;
import org.openoffice.test.vcl.client.CommunicationListener;
import org.openoffice.test.vcl.client.CommunicationManager;
import org.openoffice.test.vcl.client.Constant;
import org.openoffice.test.vcl.client.SmartId;
import org.openoffice.test.vcl.client.VclHookException;

public class CommandCaller
implements CommunicationListener,
Constant {
    private ByteArrayOutputStream dataOutput = new ByteArrayOutputStream(1024);
    private ByteArrayInputStream dataInput = null;
    private CommunicationManager communicationManager = null;
    private int sequence = 0;
    private WinInfoReceiver winInfoReceiver = null;
    private boolean receivingWinInfo = false;
    private Object response = null;
    private SmartId responseExceptionId = null;
    private String responseExceptionMessage = null;
    private boolean answered = false;

    public CommandCaller(CommunicationManager communicationManager) {
        this.communicationManager = communicationManager;
    }

    private void write(byte[] bytes) {
        try {
            this.dataOutput.write(bytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private byte[] read(int len) {
        byte[] bytes = new byte[len];
        try {
            this.dataInput.read(bytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bytes;
    }

    private void writeChar(int i) {
        byte[] bytes = new byte[2];
        bytes[1] = (byte)((i & 0xFF00) >> 8);
        bytes[0] = (byte)(i & 0xFF);
        this.write(bytes);
    }

    private int readChar() {
        byte[] bytes = this.read(2);
        return (bytes[0] & 0xFF) + ((bytes[1] & 0xFF) << 8);
    }

    private int nextType() {
        this.dataInput.mark(0);
        int type = this.readChar();
        this.dataInput.reset();
        return type;
    }

    private void writeUShort(int i) {
        this.writeChar(11);
        this.writeChar(i);
    }

    private int readUShort() {
        if (this.readChar() != 11) {
            throw new RuntimeException("Bad data!");
        }
        byte[] bytes = this.read(2);
        return (bytes[0] & 0xFF) + ((bytes[1] & 0xFF) << 8);
    }

    private void writeULong(long i) {
        this.writeChar(14);
        byte[] bytes = new byte[4];
        bytes[3] = (byte)((i & 0xFF000000L) >> 24);
        bytes[2] = (byte)((i & 0xFF0000L) >> 16);
        bytes[1] = (byte)((i & 0xFF00L) >> 8);
        bytes[0] = (byte)(i & 0xFFL);
        this.write(bytes);
    }

    private long readULong() {
        if (this.readChar() != 14) {
            throw new RuntimeException("Bad data!");
        }
        byte[] bytes = this.read(4);
        return ((long)bytes[0] & 0xFFL) + (((long)bytes[1] & 0xFFL) << 8) + (((long)bytes[2] & 0xFFL) << 16) + (((long)bytes[3] & 0xFFL) << 24);
    }

    private void writeBoolean(boolean bBool) {
        this.writeChar(13);
        this.write(new byte[]{bBool ? (byte)1 : 0});
    }

    private boolean readBoolean() {
        if (this.readChar() != 13) {
            throw new RuntimeException("Bad data!");
        }
        byte[] bytes = this.read(1);
        return bytes[0] != 0;
    }

    private void writeString(String str) {
        this.writeChar(12);
        int len = str.length();
        if (len > 65535) {
            throw new RuntimeException("String is too long.");
        }
        this.writeChar(len);
        char[] chars = str.toCharArray();
        int i = 0;
        while (i < len) {
            this.writeChar(chars[i]);
            ++i;
        }
    }

    private String readString() {
        if (this.readChar() != 12) {
            throw new RuntimeException("Bad data!");
        }
        int len = this.readChar();
        char[] chars = new char[len];
        int i = 0;
        while (i < len) {
            chars[i] = (char)this.readChar();
            ++i;
        }
        return new String(chars);
    }

    private void writeParams(Object[] args) {
        int nParams = 0;
        int nNr1 = 0;
        int nNr2 = 0;
        int nNr3 = 0;
        int nNr4 = 0;
        long nLNr1 = 0L;
        String aString1 = null;
        String aString2 = null;
        boolean bBool1 = false;
        boolean bBool2 = false;
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                if (args[i] instanceof Short || args[i] instanceof Integer) {
                    int c = ((Number)args[i]).intValue();
                    if ((nParams & 1) == 0) {
                        nParams |= 1;
                        nNr1 = c;
                    } else if ((nParams & 2) == 0) {
                        nParams |= 2;
                        nNr2 = c;
                    } else if ((nParams & 0x100) == 0) {
                        nParams |= 0x100;
                        nNr3 = c;
                    } else if ((nParams & 0x200) == 0) {
                        nParams |= 0x200;
                        nNr4 = c;
                    }
                } else if (args[i] instanceof Long) {
                    long l = (Long)args[i];
                    nParams |= 4;
                    nLNr1 = l;
                } else if (args[i] instanceof Boolean) {
                    if ((nParams & 0x40) == 0) {
                        nParams |= 0x40;
                        bBool1 = (Boolean)args[i];
                    } else if ((nParams & 0x80) == 0) {
                        nParams |= 0x80;
                        bBool2 = (Boolean)args[i];
                    }
                } else if (args[i] instanceof String) {
                    if ((nParams & 0x10) == 0) {
                        nParams |= 0x10;
                        aString1 = (String)args[i];
                    } else if ((nParams & 0x20) == 0) {
                        nParams |= 0x20;
                        aString2 = (String)args[i];
                    }
                }
                ++i;
            }
        }
        this.writeUShort(nParams);
        if ((nParams & 1) != 0) {
            this.writeUShort(nNr1);
        }
        if ((nParams & 2) != 0) {
            this.writeUShort(nNr2);
        }
        if ((nParams & 0x100) != 0) {
            this.writeUShort(nNr3);
        }
        if ((nParams & 0x200) != 0) {
            this.writeUShort(nNr4);
        }
        if ((nParams & 4) != 0) {
            this.writeULong(nLNr1);
        }
        if ((nParams & 0x10) != 0) {
            this.writeString(aString1);
        }
        if ((nParams & 0x20) != 0) {
            this.writeString(aString2);
        }
        if ((nParams & 0x40) != 0) {
            this.writeBoolean(bBool1);
        }
        if ((nParams & 0x80) != 0) {
            this.writeBoolean(bBool2);
        }
    }

    private void send() {
        byte[] data = this.dataOutput.toByteArray();
        this.dataOutput.reset();
        int protocal = 1;
        byte[] header = new byte[]{(byte)(protocal >>> 8 & 0xFF), (byte)(protocal >>> 0 & 0xFF)};
        this.communicationManager.sendPackage(1, header, data);
    }

    @Override
    public synchronized void received(int headerType, byte[] header, byte[] data) {
        if (headerType != 2) {
            this.dataInput = new ByteArrayInputStream(data);
            this.handleResponse();
            this.dataInput = null;
            this.answered = true;
            this.notifyAll();
        }
    }

    @Override
    public void start() {
    }

    @Override
    public synchronized void stop() {
        this.answered = true;
        this.notifyAll();
    }

    private SmartId readId() {
        int type = this.nextType();
        if (type == 12) {
            return new SmartId(this.readString());
        }
        if (type == 14) {
            return new SmartId(this.readULong());
        }
        throw new RuntimeException("Bad data!");
    }

    private void handleResponse() {
        this.response = null;
        this.responseExceptionId = null;
        this.responseExceptionMessage = null;
        block9: while (this.dataInput.available() >= 2) {
            int id = this.readUShort();
            switch (id) {
                case 12: {
                    int returnType = this.readUShort();
                    SmartId sid = this.readId();
                    int nNr1 = 0;
                    long nLNr1 = 0L;
                    String aString1 = null;
                    boolean bBool1 = false;
                    int params = this.readUShort();
                    if ((params & 1) != 0) {
                        nNr1 = this.readUShort();
                    }
                    if ((params & 4) != 0) {
                        nLNr1 = this.readULong();
                    }
                    if ((params & 0x10) != 0) {
                        aString1 = this.readString();
                    }
                    if ((params & 0x40) != 0) {
                        bBool1 = this.readBoolean();
                    }
                    switch (returnType) {
                        case 132: {
                            if (sid.getId() == (long)this.sequence) break;
                            this.responseExceptionMessage = "Bad sequence of command.";
                            break;
                        }
                        case 133: {
                            ArrayList<Object> ret = new ArrayList<Object>();
                            if ((params & 1) != 0) {
                                ret.add(new Integer(nNr1));
                            }
                            if ((params & 4) != 0) {
                                ret.add(new Long(nLNr1));
                            }
                            if ((params & 0x10) != 0) {
                                ret.add(aString1);
                            }
                            if ((params & 0x40) != 0) {
                                ret.add(new Boolean(bBool1));
                            }
                            this.response = ret.size() == 1 ? ret.get(0) : ret;
                            break;
                        }
                        case 134: {
                            if (bBool1) {
                                this.receivingWinInfo = true;
                                if (this.winInfoReceiver == null) break;
                                this.winInfoReceiver.onStartReceiving();
                                break;
                            }
                            if (this.winInfoReceiver == null) break;
                            this.winInfoReceiver.addWinInfo(sid, nLNr1, aString1);
                        }
                    }
                    continue block9;
                }
                case 13: {
                    this.responseExceptionId = this.readId();
                    this.responseExceptionMessage = this.readString();
                }
            }
        }
        if (this.receivingWinInfo) {
            if (this.winInfoReceiver != null) {
                this.winInfoReceiver.onFinishReceiving();
            }
            this.receivingWinInfo = false;
        }
    }

    public void setWinInfoReceiver(WinInfoReceiver receiver) {
        this.winInfoReceiver = receiver;
    }

    private void callFlow(int nArt) {
        this.writeUShort(5);
        this.writeUShort(nArt);
        this.writeUShort(0);
    }

    private void callFlow(int nArt, long nLNr1) {
        this.writeUShort(5);
        this.writeUShort(nArt);
        this.writeUShort(4);
        this.writeULong(nLNr1);
    }

    public synchronized Object callCommand(int methodId, Object[] args) {
        this.beginBlock();
        this.writeUShort(6);
        this.writeUShort(methodId);
        this.writeParams(args);
        this.endBlock();
        if ((methodId & 0x200) != 0) {
            return this.response;
        }
        return null;
    }

    public synchronized Object callControl(SmartId uid, int methodId, Object[] args) {
        this.beginBlock();
        if (uid.getSid() != null) {
            this.writeUShort(8);
            this.writeString(uid.getSid());
        } else {
            this.writeUShort(3);
            this.writeULong(uid.getId());
        }
        this.writeUShort(methodId);
        this.writeParams(args);
        this.endBlock();
        if ((methodId & 0x200) != 0) {
            return this.response;
        }
        return null;
    }

    public synchronized void callUNOSlot(String url) {
        this.beginBlock();
        this.writeUShort(7);
        this.writeString(url);
        this.endBlock();
    }

    public synchronized void callSlot(int id, Object[] args) {
        this.beginBlock();
        this.writeUShort(4);
        this.writeUShort(id);
        if (args.length % 2 != 0) {
            throw new RuntimeException("bad arg");
        }
        this.writeUShort(args.length / 2);
        int i = 0;
        while (i < args.length) {
            if (!(args[i] instanceof String)) {
                throw new RuntimeException("bad arg");
            }
            this.writeString((String)args[i]);
            if (args[++i] instanceof Boolean) {
                this.writeBoolean((Boolean)args[i]);
            } else if (args[i] instanceof String) {
                this.writeString((String)args[i]);
            } else if (args[i] instanceof Short || args[i] instanceof Integer) {
                this.writeUShort(((Number)args[i]).intValue());
            } else if (args[i] instanceof Long) {
                this.writeULong((Long)args[i]);
            } else {
                throw new RuntimeException("bad arg");
            }
            ++i;
        }
        this.endBlock();
    }

    private void beginBlock() {
        this.callFlow(102, ++this.sequence);
    }

    private void endBlock() {
        this.callFlow(101);
        this.answered = false;
        this.send();
        int MAX_RETRY = 240;
        int i = 0;
        while (!this.answered && i < MAX_RETRY) {
            try {
                this.wait(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++i;
        }
        if (!this.answered) {
            this.communicationManager.stop();
            throw new CommunicationException("Failed to get data from automation server!");
        }
        if (this.responseExceptionId != null || this.responseExceptionMessage != null) {
            throw new VclHookException(this.responseExceptionId, this.responseExceptionMessage);
        }
    }

    public static interface WinInfoReceiver {
        public void onStartReceiving();

        public void addWinInfo(SmartId var1, long var2, String var4);

        public void onFinishReceiving();
    }
}

