/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.test.vcl.client;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openoffice.test.vcl.client.CommunicationException;
import org.openoffice.test.vcl.client.CommunicationListener;
import org.openoffice.test.vcl.client.Constant;

public class CommunicationManager
implements Runnable,
Constant {
    private static Logger logger = Logger.getLogger("CommunicationManager");
    private static final int DEFAULT_PORT = 12479;
    private String host = "localhost";
    private int port = 12479;
    private Socket socket = null;
    private int reconnectInterval = 4000;
    private int reconnectCount = 3;
    private List<CommunicationListener> listeners = new Vector<CommunicationListener>();

    public CommunicationManager() {
        try {
            String portValue = System.getProperty("openoffice.automation.port");
            if (portValue != null) {
                this.port = Integer.parseInt(portValue);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public CommunicationManager(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public int getReconnectCount() {
        return this.reconnectCount;
    }

    public void setReconnectCount(int reconnectCount) {
        this.reconnectCount = reconnectCount;
    }

    public int getReconnectInterval() {
        return this.reconnectInterval;
    }

    public void setReconnectInterval(int reconnectInterval) {
        this.reconnectInterval = reconnectInterval;
    }

    public synchronized void sendPackage(int headerType, byte[] header, byte[] data) throws CommunicationException {
        if (this.socket == null) {
            this.start();
        }
        try {
            if (header == null) {
                header = new byte[]{};
            }
            if (data == null) {
                data = new byte[]{};
            }
            DataOutputStream os = new DataOutputStream(this.socket.getOutputStream());
            int len = 5 + header.length + data.length;
            os.writeInt(len);
            os.writeByte(CommunicationManager.calcCheckByte(len));
            os.writeChar(2 + header.length);
            os.writeChar(headerType);
            os.write(header);
            os.write(data);
            os.flush();
        }
        catch (IOException e) {
            this.stop();
            throw new CommunicationException("Failed to send data to automation server!", e);
        }
    }

    @Override
    public void run() {
        try {
            while (this.socket != null) {
                DataInputStream is = new DataInputStream(this.socket.getInputStream());
                int len = is.readInt();
                if (len == -1) {
                    len = is.readInt();
                }
                byte checkByte = is.readByte();
                if (CommunicationManager.calcCheckByte(len) != checkByte) {
                    throw new CommunicationException("Bad data package. Wrong check byte.");
                }
                int headerLen = is.readUnsignedShort();
                int headerType = is.readUnsignedShort();
                byte[] header = new byte[headerLen - 2];
                is.readFully(header);
                byte[] data = new byte[len - headerLen - 3];
                is.readFully(data);
                int i = 0;
                while (i < this.listeners.size()) {
                    this.listeners.get(i).received(headerType, header, data);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.FINEST, "Failed to receive data!", e);
            this.stop();
        }
    }

    public void addListener(CommunicationListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public synchronized void stop() {
        if (this.socket == null) {
            return;
        }
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.socket = null;
        logger.log(Level.CONFIG, "Stop Communication Manager");
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).stop();
            ++i;
        }
    }

    public synchronized boolean isConnected() {
        return this.socket != null;
    }

    public synchronized void connect() throws IOException {
        if (this.socket != null) {
            return;
        }
        try {
            this.socket = new Socket();
            this.socket.setTcpNoDelay(true);
            this.socket.setSoTimeout(240000);
            this.socket.connect(new InetSocketAddress(this.host, this.port));
            Thread thread = new Thread(this);
            thread.setDaemon(true);
            thread.start();
        }
        catch (IOException e) {
            this.socket = null;
            throw e;
        }
    }

    public synchronized void start() {
        logger.log(Level.CONFIG, "Start Communication Manager");
        int i = 0;
        while (i < this.reconnectCount) {
            try {
                this.connect();
                return;
            }
            catch (IOException e) {
                logger.log(Level.FINEST, "Failed to connect! Tried " + i, e);
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++i;
            }
        }
        throw new CommunicationException("Failed to connect automation server!");
    }

    private static byte calcCheckByte(int i) {
        int nRes = 0;
        int[] bytes = new int[]{i >>> 24 & 0xFF, i >>> 16 & 0xFF, i >>> 8 & 0xFF, i >>> 0 & 0xFF};
        nRes += bytes[0] ^ 0xF0;
        nRes += bytes[1] ^ 0xF;
        nRes += bytes[2] ^ 0xF0;
        nRes += bytes[3] ^ 0xF;
        nRes ^= nRes >>> 8;
        return (byte)nRes;
    }
}

