/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.test.vcl;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import org.openoffice.test.vcl.client.CommandCaller;
import org.openoffice.test.vcl.client.SmartId;
import org.openoffice.test.vcl.client.VclHook;

public class VclInspector
extends JFrame
implements CommandCaller.WinInfoReceiver {
    private static final long serialVersionUID = 1L;
    private JTable winInfoEditor = null;

    public VclInspector() {
        super("VCL Inspector");
    }

    private void init() {
        try {
            UIManager.getInstalledLookAndFeels();
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setSize(800, 600);
        JToolBar toolBar = new JToolBar("Tools");
        JButton button = new JButton("Inspect");
        button.setToolTipText("Inspect VCL controls.");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VclInspector.this.inspect();
            }
        });
        toolBar.add(button);
        this.add((Component)toolBar, "First");
        Object[] col = new String[]{"Type", "ID", "ToolTip"};
        DefaultTableModel model = new DefaultTableModel(null, col);
        this.winInfoEditor = new JTable(model);
        this.winInfoEditor.getColumnModel().getColumn(0).setMaxWidth(60);
        this.winInfoEditor.getColumnModel().getColumn(1).setMaxWidth(100);
        JScrollPane pane1 = new JScrollPane(this.winInfoEditor);
        this.add((Component)pane1, "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                VclHook.getCommunicationManager().stop();
                System.exit(0);
            }
        });
    }

    public void open() {
        this.init();
        this.setVisible(true);
    }

    @Override
    public void addWinInfo(final SmartId id, final long type, String t) {
        final String tooltip = t.replaceAll("%.*%.*:", "");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((DefaultTableModel)VclInspector.this.winInfoEditor.getModel()).addRow(new Object[]{type, id, tooltip});
            }
        });
    }

    @Override
    public void onStartReceiving() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((DefaultTableModel)VclInspector.this.winInfoEditor.getModel()).setRowCount(0);
            }
        });
    }

    public void inspect() {
        VclHook.invokeCommand(6150, Boolean.TRUE);
    }

    public static void main(String[] args) {
        VclInspector inspector = new VclInspector();
        VclHook.getCommandCaller().setWinInfoReceiver(inspector);
        inspector.open();
    }

    @Override
    public void onFinishReceiving() {
    }
}

