/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.test.vcl.widgets;

import java.awt.Rectangle;
import java.io.IOException;
import org.openoffice.test.common.Condition;
import org.openoffice.test.vcl.Tester;
import org.openoffice.test.vcl.client.SmartId;
import org.openoffice.test.vcl.client.VclHook;
import org.openoffice.test.vcl.widgets.VclMenu;
import org.openoffice.test.vcl.widgets.VclMenuItem;

public class VclControl {
    public static final long ACTIVE = 0L;
    public static final int WINDOW_BASE = 256;
    public static final int WINDOW_FIRST = 304;
    public static final int WINDOW_MESSBOX = 304;
    public static final int WINDOW_INFOBOX = 305;
    public static final int WINDOW_WARNINGBOX = 306;
    public static final int WINDOW_ERRORBOX = 307;
    public static final int WINDOW_QUERYBOX = 308;
    public static final int WINDOW_WINDOW = 309;
    public static final int WINDOW_SYSWINDOW = 310;
    public static final int WINDOW_WORKWINDOW = 311;
    public static final int WINDOW_FLOATINGWINDOW = 313;
    public static final int WINDOW_DIALOG = 314;
    public static final int WINDOW_MODELESSDIALOG = 315;
    public static final int WINDOW_MODALDIALOG = 316;
    public static final int WINDOW_SYSTEMDIALOG = 317;
    public static final int WINDOW_PATHDIALOG = 318;
    public static final int WINDOW_FILEDIALOG = 319;
    public static final int WINDOW_PRINTERSETUPDIALOG = 320;
    public static final int WINDOW_PRINTDIALOG = 321;
    public static final int WINDOW_COLORDIALOG = 322;
    public static final int WINDOW_FONTDIALOG = 323;
    public static final int WINDOW_CONTROL = 324;
    public static final int WINDOW_BUTTON = 325;
    public static final int WINDOW_PUSHBUTTON = 326;
    public static final int WINDOW_OKBUTTON = 327;
    public static final int WINDOW_CANCELBUTTON = 328;
    public static final int WINDOW_HELPBUTTON = 329;
    public static final int WINDOW_IMAGEBUTTON = 330;
    public static final int WINDOW_MENUBUTTON = 331;
    public static final int WINDOW_MOREBUTTON = 332;
    public static final int WINDOW_SPINBUTTON = 333;
    public static final int WINDOW_RADIOBUTTON = 334;
    public static final int WINDOW_IMAGERADIOBUTTON = 335;
    public static final int WINDOW_CHECKBOX = 336;
    public static final int WINDOW_TRISTATEBOX = 337;
    public static final int WINDOW_EDIT = 338;
    public static final int WINDOW_MULTILINEEDIT = 339;
    public static final int WINDOW_COMBOBOX = 340;
    public static final int WINDOW_LISTBOX = 341;
    public static final int WINDOW_MULTILISTBOX = 342;
    public static final int WINDOW_FIXEDTEXT = 343;
    public static final int WINDOW_FIXEDLINE = 344;
    public static final int WINDOW_FIXEDBITMAP = 345;
    public static final int WINDOW_FIXEDIMAGE = 346;
    public static final int WINDOW_GROUPBOX = 348;
    public static final int WINDOW_SCROLLBAR = 349;
    public static final int WINDOW_SCROLLBARBOX = 350;
    public static final int WINDOW_SPLITTER = 351;
    public static final int WINDOW_SPLITWINDOW = 352;
    public static final int WINDOW_SPINFIELD = 353;
    public static final int WINDOW_PATTERNFIELD = 354;
    public static final int WINDOW_NUMERICFIELD = 355;
    public static final int WINDOW_METRICFIELD = 356;
    public static final int WINDOW_CURRENCYFIELD = 357;
    public static final int WINDOW_DATEFIELD = 358;
    public static final int WINDOW_TIMEFIELD = 359;
    public static final int WINDOW_PATTERNBOX = 360;
    public static final int WINDOW_NUMERICBOX = 361;
    public static final int WINDOW_METRICBOX = 362;
    public static final int WINDOW_CURRENCYBOX = 363;
    public static final int WINDOW_DATEBOX = 364;
    public static final int WINDOW_TIMEBOX = 365;
    public static final int WINDOW_LONGCURRENCYFIELD = 366;
    public static final int WINDOW_LONGCURRENCYBOX = 367;
    public static final int WINDOW_TOOLBOX = 369;
    public static final int WINDOW_DOCKINGWINDOW = 370;
    public static final int WINDOW_STATUSBAR = 371;
    public static final int WINDOW_TABPAGE = 372;
    public static final int WINDOW_TABCONTROL = 373;
    public static final int WINDOW_TABDIALOG = 374;
    public static final int WINDOW_BORDERWINDOW = 375;
    public static final int WINDOW_BUTTONDIALOG = 376;
    public static final int WINDOW_SYSTEMCHILDWINDOW = 377;
    public static final int WINDOW_FIXEDBORDER = 378;
    public static final int WINDOW_SLIDER = 379;
    public static final int WINDOW_MENUBARWINDOW = 380;
    public static final int WINDOW_TREELISTBOX = 381;
    public static final int WINDOW_HELPTEXTWINDOW = 382;
    public static final int WINDOW_INTROWINDOW = 383;
    public static final int WINDOW_LISTBOXWINDOW = 384;
    public static final int WINDOW_DOCKINGAREA = 385;
    public static final int WINDOW_VALUESETLISTBOX = 389;
    public static final int WINDOW_LAST = 385;
    protected SmartId uid = null;
    protected int type = -1;

    public VclControl(SmartId id) {
        this.uid = id;
    }

    public VclControl(String uid) {
        this.uid = new SmartId(uid);
    }

    public SmartId getUID() {
        return this.uid;
    }

    public void click() {
        this.invoke(32);
    }

    public void click(int x, int y) {
        Rectangle rect = this.getValidScreenRectangle();
        Tester.click(rect.x + x, rect.y + y);
    }

    public void doubleClick(int x, int y) {
        Rectangle rect = this.getValidScreenRectangle();
        Tester.doubleClick(rect.x + x, rect.y + y);
    }

    public void click(double xPercent, double yPercent) {
        Rectangle rect = this.getValidScreenRectangle();
        Tester.click((int)((double)rect.x + xPercent * (double)rect.width), (int)((double)rect.y + yPercent * (double)rect.height));
    }

    public void doubleClick(double xPercent, double yPercent) {
        Rectangle rect = this.getValidScreenRectangle();
        Tester.doubleClick((int)((double)rect.x + xPercent * (double)rect.width), (int)((double)rect.y + yPercent * (double)rect.height));
    }

    public void rightClick(int x, int y) {
        Rectangle rect = this.getValidScreenRectangle();
        Tester.rightClick(rect.x + x, rect.y + y);
    }

    public void drag(int fromX, int fromY, int toX, int toY) {
        Rectangle rect = this.getValidScreenRectangle();
        Tester.drag(rect.x + fromX, rect.y + fromY, rect.x + toX, rect.y + toY);
    }

    public String getCaption() {
        return (String)this.invoke(529);
    }

    public boolean isEnabled() {
        return (Boolean)this.invoke(515);
    }

    public boolean isChecked() {
        return (Boolean)this.invoke(519);
    }

    protected int getFixedTextCount() {
        return (Integer)this.invoke(563);
    }

    protected String getFixedText(int i) {
        return (String)this.invoke(564, new Integer(i + 1));
    }

    public Object invoke(int methodId, Object ... args) {
        return VclHook.invokeControl(this.getUID(), methodId, args);
    }

    public Object invoke(int methodId) {
        return VclHook.invokeControl(this.getUID(), methodId, null);
    }

    protected void useMenu() {
        this.invoke(83);
    }

    public void inputKeys(String keys) {
        this.invoke(1074, keys);
    }

    public boolean exists(double iTimeout) {
        return this.exists(iTimeout, 1.0);
    }

    public boolean exists(double iTimeout, double interval) {
        return new Condition(){

            @Override
            public boolean value() {
                return VclControl.this.exists();
            }
        }.test(iTimeout, interval);
    }

    public void waitForExistence(double iTimeout, double interval) {
        new Condition(){

            @Override
            public boolean value() {
                return VclControl.this.exists();
            }
        }.waitForTrue(this + " is not found!", iTimeout, interval);
    }

    public void waitForEnabled(double iTimeout, double interval) {
        new Condition(){

            @Override
            public boolean value() {
                return VclControl.this.isEnabled();
            }
        }.waitForTrue("Time out to wait the control to be enabled!", iTimeout, interval);
    }

    public void waitForDisabled(double iTimeout, double interval) {
        new Condition(){

            @Override
            public boolean value() {
                return !VclControl.this.isEnabled();
            }
        }.waitForTrue("Time out to wait the control to be disabled!", iTimeout, interval);
    }

    public void waitForText(final String text, double iTimeout, double interval) {
        new Condition(){

            @Override
            public boolean value() {
                return text.equals(VclControl.this.getCaption());
            }
        }.waitForTrue("Time out to wait the control to show the text: " + text, iTimeout, interval);
    }

    public int getType() {
        if (this.type == -1) {
            this.type = ((Long)this.invoke(532)).intValue();
        }
        return this.type;
    }

    public boolean exists() {
        try {
            VclHook.getCommunicationManager().connect();
        }
        catch (IOException e) {
            return false;
        }
        return (Boolean)this.invoke(513);
    }

    public void focus() {
        this.inputKeys("");
    }

    public Rectangle getScreenRectangle() {
        String ret = (String)this.invoke(604, Boolean.FALSE);
        if (ret == null) {
            return null;
        }
        String[] data = ret.split(",");
        int x = Integer.parseInt(data[0]);
        int y = Integer.parseInt(data[1]);
        int w = Integer.parseInt(data[2]);
        int h = Integer.parseInt(data[3]);
        return new Rectangle(x, y, w, h);
    }

    public Rectangle getValidScreenRectangle() {
        Rectangle rect = this.getScreenRectangle();
        if (rect == null) {
            throw new RuntimeException(this + " - screen rectangle could not be computed! Maybe it is not showing!");
        }
        return rect;
    }

    public VclMenuItem menuItem(String path) {
        return new VclMenuItem(new VclMenu(this), path);
    }

    public void openContextMenu() {
        this.invoke(57);
    }

    public String toString() {
        if (this.uid != null) {
            return this.uid.toString();
        }
        return null;
    }
}

