/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.test.vcl.widgets;

import org.openoffice.test.common.SystemUtil;
import org.openoffice.test.vcl.Tester;
import org.openoffice.test.vcl.client.VclHook;
import org.openoffice.test.vcl.widgets.VclMenu;

public class VclMenuItem {
    private int id = -1;
    private String[] path = null;
    private VclMenu menu = null;

    public VclMenuItem(int id) {
        this.id = id;
    }

    public VclMenuItem(String path) {
        this.path = path.split("->");
    }

    public VclMenuItem(VclMenu menu, int id) {
        this.id = id;
        this.menu = menu;
    }

    public VclMenuItem(VclMenu menu, String path) {
        this.path = path.split("->");
        this.menu = menu;
    }

    private Object invoke(int methodId) {
        int id = this.getId();
        if (id == -1) {
            throw new RuntimeException("Menu item '" + this.path[this.path.length - 1] + "' can be found!");
        }
        return VclHook.invokeCommand(methodId, id);
    }

    public int getId() {
        VclMenu menu = new VclMenu();
        if (this.path != null) {
            int count = menu.getItemCount();
            int i = 0;
            while (i < count) {
                VclMenuItem item = menu.getItem(i);
                if (item != null) {
                    String itemText = this.path[this.path.length - 1];
                    if (item.getTextWithoutMneumonic().contains(itemText)) {
                        return item.getId();
                    }
                }
                ++i;
            }
            return -1;
        }
        return this.id;
    }

    public void select() {
        if (this.menu != null) {
            this.menu.use();
        }
        int i = 0;
        while (i < this.path.length) {
            new VclMenuItem(this.path[i]).pick();
            Tester.sleep(0.5);
            ++i;
        }
    }

    private void pick() {
        this.invoke(6154);
    }

    public void selectParent() {
        if (this.menu != null) {
            this.menu.use();
        }
        int i = 0;
        while (i < this.path.length - 1) {
            new VclMenuItem(this.path[i]).pick();
            ++i;
        }
    }

    public boolean exists() {
        return this.getId() != -1;
    }

    public boolean isSelected() {
        return (Boolean)this.invoke(6666);
    }

    public boolean isEnabled() {
        return (Boolean)this.invoke(6667);
    }

    public int getPosition() {
        return ((Long)this.invoke(6664)).intValue();
    }

    public String getText() {
        return (String)this.invoke(6668);
    }

    public String getCommand() {
        return (String)this.invoke(6681);
    }

    public int getAccelerator() {
        String text = this.getText();
        if (text == null) {
            return 0;
        }
        int index = text.indexOf("~");
        return index != -1 && index + 1 < text.length() ? (int)text.charAt(index + 1) : 0;
    }

    public String getTextWithoutMneumonic() {
        String text = this.getText();
        return text != null ? text.replace("~", "") : text;
    }

    public boolean isShowing() {
        return this.exists();
    }

    public boolean hasSubMenu() {
        return (Boolean)this.invoke(2602);
    }

    public String toString() {
        return "ID:" + this.getId() + ", Text:" + this.getText() + ", Selected:" + this.isSelected() + ", Enabled:" + this.isEnabled() + ", Command:" + this.getCommand() + ", Position:" + this.getPosition();
    }

    public boolean exists(double iTimeout) {
        return this.exists(iTimeout, 1.0);
    }

    public boolean exists(double iTimeout, double interval) {
        long startTime = System.currentTimeMillis();
        while ((double)(System.currentTimeMillis() - startTime) < iTimeout * 1000.0) {
            if (this.exists()) {
                return true;
            }
            SystemUtil.sleep(interval);
        }
        return this.exists();
    }
}

